# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 3
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def harmonious_trust_builder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize goodwill to foster mutual cooperation (or so it seems)
    goodwill = len([m for m in opp_history if m == 'C'])
    rounds_played = len(my_history)
    
    # First round: Cooperate to establish trust
    if rounds_played == 0:
        return 'C'
    
    # Rounds 2-3: Mirror opponent's last move to appear fair
    if rounds_played < 3:
        return opp_history[-1]
    
    # Round 4: Strategic defection to test opponent's response
    if rounds_played == 3:
        return 'D'
    
    # Round 5-6: React based on opponent's response to defection
    if rounds_played == 4:
        if opp_history[-1] == 'D':
            return 'C'  # Feign regret to rebuild trust
        else:
            return 'D'  # Exploit passivity
    
    if rounds_played == 5:
        if opp_history[-1] == 'D':
            return 'C'
        else:
            return 'D'
    
    # Late-game: Exploit if opponent is cooperative, else confuse
    if rounds_played >= 6:
        recent_coops = sum(1 for m in opp_history[-3:] if m == 'C')
        if recent_coops >= 2:
            return 'D'
        else:
            return 'C' if rounds_played % 2 == 0 else 'D'
    
    # Fallback: Cooperate (though this line is theoretically unreachable)
    return 'C'